/* $PostgresPy: if/src/void.c,v 1.1 2004/06/28 23:42:19 flaw Exp $
 *
 * † Instrument:
 *     Copyright 2004, rhid development. All Rights Reserved.
 *     
 *     Usage of the works is permitted provided that this
 *     instrument is retained with the works, so that any entity
 *     that uses the works is notified of this instrument.
 *     
 *     DISCLAIMER: THE WORKS ARE WITHOUT WARRANTY.
 *     
 *     [2004, Fair License; rhid.com/fair]
 *     
 *//*
 * Void Object, similar to NoneType, but with the capacity to create similars.
 */
#include <pputils.h>
#include <Python.h>
#include <structmember.h>
#include <py.h>

#include "void.h"

static void
void_dealloc(PyObj self)
{
	PyObject_Del(self);
}

static PyObj
void_repr(PyObj self)
{
	return(PYSTR("<Void Object>"));
}

static int
void_cmp(PyObj self, PyObj with)
{
	if (self == with)
		return(0);

	return(-1);
}

static char PyVoid_Doc[] = "Empty Object";
PyTypeObject PyVoid_Type = {
	PyObject_HEAD_INIT(NULL)
	0,										/* ob_size */
	"Void",								/* tp_name */
	sizeof(struct _void),			/* tp_basicsize */
	0,										/* tp_itemsize */
	(destructor)void_dealloc,		/* tp_dealloc */
	NULL,									/* tp_print */
	(getattrfunc)NULL,				/* tp_getattr */
	(setattrfunc)NULL,				/* tp_setattr */
	(cmpfunc)void_cmp,				/* tp_compare */
	(reprfunc)void_repr,				/* tp_repr */
	NULL,									/* tp_as_number */
	NULL,									/* tp_as_sequence */
	NULL,									/* tp_as_mapping */
	(hashfunc)NULL,					/* tp_hash */
	(ternaryfunc)NULL,				/* tp_call */
	(reprfunc)NULL,					/* tp_str */
	NULL,									/* tp_getattro */
	NULL,									/* tp_setattro */
	NULL,									/* tp_as_buffer */
	Py_TPFLAGS_DEFAULT,			   /* tp_flags */
	(char*)PyVoid_Doc,				/* tp_doc */
	(traverseproc)NULL,				/* tp_traverse */
	(inquiry)NULL,						/* tp_clear */
	(richcmpfunc)NULL,				/* tp_richcompare */
	(long)0,								/* tp_weaklistoffset */
	(getiterfunc)NULL,				/* tp_iter */
	(iternextfunc)NULL,				/* tp_iternext */
	NULL,									/* tp_methods */
	NULL,									/* tp_members */
	NULL,									/* tp_getset */
	NULL,									/* tp_base */
	NULL,									/* tp_dict */
	NULL,									/* tp_descr_get */
	NULL,									/* tp_descr_set */
	NULL,									/* tp_dictoffset */
	NULL,									/* tp_init */
	NULL,									/* tp_alloc */
	PyType_GenericNew,				/* tp_new */
};

PyObj
PyVoid_New(void)
{
	PyObj rob;
	rob = (PyObj)PyVoid_Type.tp_alloc(&PyVoid_Type, 0);
	return(rob);
}
